/*
 * Decompiled with CFR 0.152.
 */
package morph.avaritia.tile;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.inventory.InventorySimple;
import codechicken.lib.inventory.InventoryUtils;
import codechicken.lib.util.ItemUtils;
import morph.avaritia.init.AvaritiaModContent;
import morph.avaritia.tile.MachineTileBase;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class NeutronCollectorTile
extends MachineTileBase {
    public static final int PRODUCTION_TICKS = 7111;
    public final InventorySimple inventory = new InventorySimple(1){

        public void m_6596_() {
            NeutronCollectorTile.this.m_6596_();
        }
    };
    private int progress;
    private LazyOptional<InvWrapper> capWrapper = LazyOptional.of(() -> new InvWrapper((Container)this.inventory));

    public NeutronCollectorTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)AvaritiaModContent.NEUTRON_COLLECTOR_TILE.get(), pos, state);
    }

    @Override
    protected void doWork() {
        if (++this.progress >= 7111) {
            ItemStack slot = this.inventory.m_8020_(0);
            if (slot.m_41619_()) {
                this.inventory.m_6836_(0, new ItemStack((ItemLike)AvaritiaModContent.NEUTRON_PILE.get()));
            } else if (slot.m_150930_((Item)AvaritiaModContent.NEUTRON_PILE.get()) && slot.m_41613_() < 64) {
                this.inventory.m_6836_(0, ItemUtils.copyStack((ItemStack)slot, (int)(slot.m_41613_() + 1)));
            }
            this.progress = 0;
        }
    }

    @Override
    protected void onWorkStopped() {
        this.progress = 0;
    }

    @Override
    protected boolean canWork() {
        return this.inventory.m_8020_(0).m_41619_() || this.inventory.m_8020_(0).m_41613_() < 64;
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("inventory", (Tag)InventoryUtils.writeItemStacksToTag((ItemStack[])this.inventory.items));
        tag.m_128405_("progress", this.progress);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        InventoryUtils.readItemStacksFromTag((ItemStack[])this.inventory.items, (ListTag)tag.m_128437_("inventory", 10));
        this.progress = tag.m_128451_("progress");
    }

    @Override
    public void writeGuiData(MCDataOutput packet, boolean isFullSync) {
        packet.writeVarInt(this.progress);
    }

    @Override
    public void readGuiData(MCDataInput packet, boolean isFullSync) {
        this.progress = packet.readVarInt();
    }

    public int getProgress() {
        return this.progress;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, Direction side) {
        if (!this.f_58859_ && cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.capWrapper.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.capWrapper.invalidate();
    }

    public void reviveCaps() {
        super.reviveCaps();
        this.capWrapper = LazyOptional.of(() -> new InvWrapper((Container)this.inventory));
    }
}

